*! version 5.0
* 13 August 2018
* NIDS
* Coding employment status

*====================================================================================================================================

* NOTE		

/*

The following variables were used in the original do-file, they are listed with their variable name which is consistent across waves
as well as the corresponding question number in each wave. 

variable name		w1				w2             w3				w4				w5
em1 			->	e1			->	e2         ->  e2			->	eb1			->	eb1
em2				->	e18			->	e23        ->  e23			->	eb16		->	eb16
ems				->	e28			->	e33        ->  e33			->	ec1			->	ec1
emc				->	e40			->	e48        ->  e48			->	ed1			->	ed1
emp				->	e45			->	e53        ->  e53			->	ee1			->	ee1
emh				->	e52			->	e61        ->  e61			->	ef1			->	ef1
unemwnt			->	e66			->	e74        ->  e74			->	eg6			->	eg6
unems*			->	e71_1a 		->	e79*       ->  e79*			->	eg11*		->	eg11*

*/

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\W1"    			//File path to where data is located. Change this path according to where your data folder in located on your computer.
global DataOUT "C:\Users\Admin\Desktop\W1"

global temp "C:\Users\Admin\Desktop\W1"					// tempfile to hold all the working datasets, all working datasets will
														// be deleted from this folder at the completion of the do file execution.
global VersionIN "W1_Anon_V7.0.0.dta"
global VersionOUT "Derived"																

version 12.0											// version of Stata being used, this is needed for the rename command.

set more off
*=====================================================================================================================================================

* ADULT

use "$DataIN\Adult_$VersionIN", clear

* Rename all the variables
rename	w1_a_em1	e1
rename	w1_a_em1strtm	e2_m
rename	w1_a_em1strty	e2_y
rename	w1_a_em1inf	e3
rename	w1_a_em1occ_isco_c	e4_code
rename	w1_a_em1prod_c	e7_code
rename	w1_a_em1inc	e8
rename	w1_a_em1pay	e9
rename	w1_a_em1inc_s	e10
rename	w1_a_em1hrs	e11
rename	w1_a_em1cheq	e12_1
rename	w1_a_em1cheq_a	e12_1a
rename	w1_a_em1prf	e12_2
rename	w1_a_em1prf_a	e12_2a
rename	w1_a_em1bon	e12_3
rename	w1_a_em1bon_a	e12_3a
rename	w1_a_em1pcrt	e12_4
rename	w1_a_em1pcrt_a	e12_4a
rename	w1_a_em1dedmed	e12_5
rename	w1_a_em1dedpen	e12_6
rename	w1_a_em1deduif	e12_7
rename	w1_a_em1contr	e13_1
rename	w1_a_em1contr_d	e13_2
rename	w1_a_em1tru	e14
rename	w1_a_em1trncst	e15
rename	w1_a_em1prv	e16
rename	w1_a_em1prv_dy	e17_y
rename	w1_a_em1prv_dm	e17_m
rename	w1_a_em2	e18
rename	w1_a_em2strtm	e19_m
rename	w1_a_em2strty	e19_y
rename	w1_a_em2occ_isco_c	e20_code
rename	w1_a_em2prod_c	e23_code
rename	w1_a_em2inc	e24
rename	w1_a_em2pay	e25
rename	w1_a_em2inc_sh	e26
rename	w1_a_em2hrs	e27
rename	w1_a_ems	e28
rename	w1_a_emsatc_isco_c	e29_code
rename	w1_a_emsoth	e30
rename	w1_a_emsmn	e32
rename	w1_a_emsincmn	e33
rename	w1_a_emsinc_sh	e34
rename	w1_a_emsincyr	e35
rename	w1_a_emshrs	e36
rename	w1_a_emstax	e37
rename	w1_a_emsmch	e38
rename	w1_a_emsmch_v	e39
rename	w1_a_emc	e40
rename	w1_a_emctype_isco_c	e41_code
rename	w1_a_emcinc	e42
rename	w1_a_emcinc_sh	e43
rename	w1_a_emchrs	e44
rename	w1_a_emp	e45
rename	w1_a_emphrs	e46
rename	w1_a_empsll	e47
rename	w1_a_empser	e48
rename	w1_a_empsll_v	e50
rename	w1_a_empser_v	e51
rename	w1_a_emh	e52
rename	w1_a_emhhrs	e53
rename	w1_a_emhper	e54
rename	w1_a_emhearn	e55
rename	w1_a_emhearn_v	e56
rename	w1_a_emhtsk_isco_c	e57_code
rename	w1_a_unemprv	e62
rename	w1_a_unemdc	e63
rename	w1_a_unemtyp_isco_c	e64_code
rename	w1_a_unemex	e65
rename	w1_a_unemwnt	e66
rename	w1_a_unemwnt_dy	e67_y
rename	w1_a_unemwnt_dm	e67_m
rename	w1_a_unemrj	e68
rename	w1_a_unemrjex	e69
rename	w1_a_unemmn	e70_1
rename	w1_a_unenl6mn	e70_2
rename	w1_a_unemyr	e70_3
rename	w1_a_unem2yr	e70_4
rename	w1_a_unems1	e71_1a
rename	w1_a_unems2	e71_2a
rename	w1_a_unems3	e71_3a
rename	w1_a_unems4	e71_4a
rename	w1_a_unems5	e71_5a
rename	w1_a_unems6	e71_6a
rename	w1_a_unems7	e71_7a
rename	w1_a_unems8	e71_8a
rename	w1_a_unems9	e71_9a
rename	w1_a_unems10	e71_10a
rename	w1_a_unemsrcst	e72
rename	w1_a_unemsrsrc	e73
rename	w1_a_unemava	e74
rename	w1_a_unemavaexp	e75
rename	w1_a_noemex	e76
rename	w1_a_noemsr	e77
rename	w1_a_noemsryr	e78
rename	w1_a_noemsrex	e79

gen Employed= (e1==1|e18==1|e28==1|e40==1|e45==1|e52==1)
gen Not_economically_active= (Employed==0 & e66==2)
gen Unemployed_discouraged= (Employed==0 & e66==1 & e71_1a==11)
gen Unemployed_strict= (Employed==0 & e66==1 & e71_1a>=1 & e71_1a<=10)

gen state=.
replace state=0 if Not_economically_active==1
replace state=1 if Unemployed_discouraged==1
replace state=2 if Unemployed_strict==1
replace state=3 if Employed==1

replace state=. if w1_a_refexpl!=.

la def state 0"Not Economically Active" 1"Unemployed_Discouraged" 2"Unemployed_Strict" 3"Employed"
la val state state

ren state state_fine_a

* Notes:
* 1. Some freedom to classify between searchers and non-searchers using e74, we made no use of e74 in our derivation
* 2. 150 Obs cannot be classified due to missing data or non-response on some variables. Most of them are not employed.

gen state2=0 if state_fine_a == 0
replace state2=1 if state_fine_a >=1 & state_fine_a <=2
replace state2=2 if state_fine_a ==3

la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed"
la val state2 state2
ren state2 state_coarse_a

keep pid state_fine_a  state_coarse_a
sort  pid


save "$DataOUT\1_labour", replace

*=================================================================================================================================

* PROXY

use "$DataIN\Proxy_$VersionIN", clear

gen state2=.
 replace state2=0 if w1_p_emactcur_u>=5 & w1_p_emactcur_u<=8
 replace state2=2 if w1_p_emactcur_u>=1 & w1_p_emactcur_u<=4
 replace state2=1 if w1_p_emactcur_u==9

la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed"
la val state2 state2
ren state2 state_coarse_p


keep pid state_coarse_p
sort pid
***

save "$DataOUT\2_labour", replace


*=================================================================================================================================

* INDDERIVED

use "$DataIN\indderived_$VersionIN", clear

cap drop  w1_empl_stat w1_empl_stat_inclprox

sort pid
merge 1:1 pid using "$DataOUT\1_labour.dta"
drop _merge
sort pid
merge 1:1 pid using "$DataOUT\2_labour.dta"
drop _merge
gen state_coarse_ap = .
replace state_coarse_ap = state_coarse_a if state_coarse_a !=.
replace state_coarse_ap = state_coarse_p if state_coarse_p !=.

la val state_coarse_ap state_coarse_ap

ren state_coarse_ap w1_empl_stat_inclprox
ren state_fine_a w1_empl_stat

lab var w1_empl_stat_inclprox "Employment status - including Proxy"
lab var  w1_empl_stat "Employment status - Adult only"

drop state_coarse_a state_coarse_p

save "$DataOUT\indderived_$VersionOUT", replace


*=================================================================================================================================

* END





